<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use WP_SMS\Admin\LicenseManagement\LicenseHelper;

$is_pro = LicenseHelper::isPluginLicensedAndActive();
?>

<form method="post">

    <div class="u-flex u-flex--column u-align-center c-ready__message">
        <svg width="66" height="65" viewBox="0 0 66 65" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M32.9998 64.5833C15.2807 64.5833 0.916504 50.219 0.916504 32.5C0.916504 14.7809 15.2807 0.416687 32.9998 0.416687C50.7188 0.416687 65.0831 14.7809 65.0831 32.5C65.0831 50.219 50.7188 64.5833 32.9998 64.5833ZM29.7998 45.3333L52.4863 22.647L47.949 18.1097L29.7998 36.2589L20.7254 27.1841L16.1881 31.7217L29.7998 45.3333Z" fill="#058860"/>
        </svg>
        <h1 class="u-text-center">
            <?php esc_html_e('Onboarding process successfully completed!', 'wp-sms'); ?>
        </h1>
        <p class="u-text-center">
            <?php esc_html_e('Start sending SMS messages from your WordPress site right away.', 'wp-sms'); ?>
        </p>
        <a href="<?php echo esc_url(admin_url('/admin.php?page=wp-sms')); ?>" title="<?php esc_attr_e('start using WP SMS', 'wp-sms'); ?>" class="c-btn c-btn--primary c-btn--mainready">
            <?php esc_html_e('Start using WP SMS', 'wp-sms'); ?>
        </a>
    </div>
    <div class="c-ready-row">
        <h3 class="c-ready__title"><?php esc_html_e('Support', 'wp-sms'); ?></h3>
        <div class="c-ready__items u-flex u-align-stretch u-content-sp">
            <div class="c-readycard c-readycard__half">
                <span class="c-readycard__icon c-readycard__icon--document"></span>
                <h2 class="c-readycard__title"><?php esc_html_e('Documentation', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Find step-by-step guides for configuring WP SMS and troubleshooting common issues.', 'wp-sms'); ?>
                </p>
                <a class="c-btn" href="<?php echo esc_url('https://wp-sms-pro.com/documentation/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" target="_blank" title="<?php esc_attr_e('View', 'wp-sms'); ?>"><?php esc_html_e('View', 'wp-sms'); ?></a>
            </div>
            <div class="c-readycard c-readycard__half">
                <span class="c-readycard__icon c-readycard__icon--faq"></span>
                <h2 class="c-readycard__title"><?php esc_html_e("FAQ", 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e("Have a question or need quick answers? Check out our Frequently Asked Questions.", 'wp-sms'); ?>
                </p>
                <a class="c-btn" href="<?php echo esc_url('https://wp-sms-pro.com/faq/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" target="_blank" title="<?php esc_attr_e('View', 'wp-sms'); ?>"><?php esc_html_e('View', 'wp-sms'); ?></a>
            </div>
        </div>
    </div>
    <div class="c-ready-row">
        <h3 class="c-ready__title"><?php _e('Integrations', 'wp-sms'); ?></h3>
        <div class="c-ready__items u-flex u-align-stretch u-content-sp">
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_15902)">
                        <path d="M15 30C23.2843 30 30 23.2843 30 15C30 6.71573 23.2843 0 15 0C6.71573 0 0 6.71573 0 15C0 23.2843 6.71573 30 15 30Z" fill="#9B5C8F"/>
                        <path d="M7.36527 10.0078H22.6289C23.5957 10.0078 24.375 10.7871 24.375 11.7539V17.5781C24.375 18.5449 23.5957 19.3242 22.6289 19.3242H17.1563L17.9063 21.1641L14.6016 19.3242H7.37113C6.40433 19.3242 5.62503 18.5449 5.62503 17.5781V11.7539C5.61917 10.793 6.39847 10.0078 7.36527 10.0078Z" fill="white"/>
                        <path
                            d="M6.69151 11.6017C6.79698 11.4552 6.96104 11.3791 7.17198 11.3673C7.5587 11.338 7.78135 11.5197 7.83409 11.9181C8.06846 13.5119 8.33213 14.8595 8.60167 15.9669L10.2716 12.7912C10.4239 12.5041 10.6173 12.3517 10.8458 12.3341C11.1798 12.3107 11.3849 12.5275 11.4728 12.9728C11.6661 13.9865 11.9064 14.8478 12.1993 15.5802C12.3985 13.6466 12.7325 12.2521 13.2071 11.3908C13.3243 11.1798 13.4884 11.0685 13.711 11.0568C13.8868 11.0392 14.045 11.0978 14.1915 11.2091C14.338 11.3205 14.4142 11.4669 14.4259 11.6427C14.4317 11.7775 14.4083 11.8947 14.3497 12.006C14.0509 12.5568 13.8106 13.4767 13.6114 14.7599C13.4181 16.0021 13.3536 16.9689 13.4005 17.6662C13.4181 17.8595 13.3829 18.0236 13.3067 18.1701C13.213 18.34 13.0782 18.4279 12.9024 18.4455C12.7032 18.463 12.4981 18.3693 12.2989 18.1642C11.5899 17.4376 11.0274 16.3595 10.6173 14.9181C10.1192 15.8966 9.75596 16.6232 9.52159 17.1154C9.07042 17.9767 8.68956 18.4162 8.37315 18.4396C8.16807 18.4572 7.99229 18.2814 7.83995 17.9123C7.45323 16.9162 7.03135 14.9826 6.58018 12.1291C6.53917 11.9123 6.58604 11.7365 6.69151 11.6017ZM23.0743 12.797C22.7989 12.3166 22.3946 12.0294 21.8556 11.9123C21.7091 11.883 21.5743 11.8654 21.4454 11.8654C20.713 11.8654 20.1212 12.2462 19.6524 13.008C19.254 13.6584 19.0606 14.3732 19.0606 15.1584C19.0606 15.7443 19.1837 16.2482 19.4239 16.6701C19.6993 17.1505 20.1036 17.4377 20.6427 17.5548C20.7892 17.5841 20.9239 17.6017 21.0528 17.6017C21.7911 17.6017 22.3888 17.2209 22.8458 16.4591C23.2442 15.8029 23.4376 15.088 23.4376 14.3029C23.4435 13.7052 23.3146 13.2072 23.0743 12.797ZM22.1134 14.9064C22.0079 15.4103 21.8146 15.7853 21.5333 16.0373C21.3106 16.2365 21.1056 16.3185 20.9181 16.2834C20.7364 16.2423 20.5841 16.0841 20.4669 15.7853C20.3731 15.5509 20.3321 15.3107 20.3321 15.0939C20.3321 14.9005 20.3497 14.713 20.3849 14.5373C20.4552 14.2267 20.5841 13.922 20.7892 13.6291C21.0411 13.2541 21.3048 13.1017 21.5802 13.1544C21.7618 13.1955 21.9142 13.3537 22.0314 13.6525C22.1251 13.8869 22.1661 14.1271 22.1661 14.3439C22.1661 14.5431 22.1485 14.7306 22.1134 14.9064ZM18.2989 12.797C18.0235 12.3166 17.6134 12.0294 17.0802 11.9123C16.9337 11.883 16.7989 11.8654 16.67 11.8654C15.9376 11.8654 15.3458 12.2462 14.8771 13.008C14.4786 13.6584 14.2853 14.3732 14.2853 15.1584C14.2853 15.7443 14.4083 16.2482 14.6485 16.6701C14.9239 17.1505 15.3282 17.4377 15.8673 17.5548C16.0138 17.5841 16.1485 17.6017 16.2774 17.6017C17.0157 17.6017 17.6134 17.2209 18.0704 16.4591C18.4689 15.8029 18.6622 15.088 18.6622 14.3029C18.6681 13.7052 18.545 13.2072 18.2989 12.797ZM17.3321 14.9064C17.2267 15.4103 17.0333 15.7853 16.7521 16.0373C16.5294 16.2365 16.3243 16.3185 16.1368 16.2834C15.9552 16.2423 15.8028 16.0841 15.6856 15.7853C15.5919 15.5509 15.5509 15.3107 15.5509 15.0939C15.5509 14.9005 15.5685 14.713 15.6036 14.5373C15.6739 14.2267 15.8028 13.922 16.0079 13.6291C16.2599 13.2541 16.5235 13.1017 16.7989 13.1544C16.9806 13.1955 17.1329 13.3537 17.2501 13.6525C17.3439 13.8869 17.3849 14.1271 17.3849 14.3439C17.3966 14.5431 17.3731 14.7306 17.3321 14.9064Z"
                            fill="#9B5C8F"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_15902">
                            <rect width="30" height="30" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <a class="c-readycard__title" target="_blank" title="<?php esc_attr_e('WooCommerce', 'wp-sms'); ?>" href="<?php echo esc_url('https://wp-sms-pro.com/woocommerce-sms-integration/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>">
                    <?php esc_html_e('WooCommerce', 'wp-sms'); ?>
                </a>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Boost sales and customer satisfaction with instant order updates, automated cart recovery, SMS login, targeted campaigns, etc.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_20084)">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M21.5477 0.000225626C21.0563 0.00787148 20.588 0.209518 20.2457 0.560864C19.9035 0.912209 19.7152 1.38451 19.7224 1.87402V11.8098C19.7189 12.0546 19.7643 12.2976 19.8559 12.5247C19.9475 12.7518 20.0836 12.9586 20.2561 13.1329C20.4287 13.3072 20.6343 13.4456 20.861 13.54C21.0877 13.6345 21.331 13.6831 21.5767 13.6831C21.8225 13.6831 22.0658 13.6345 22.2925 13.54C22.5192 13.4456 22.7248 13.3072 22.8973 13.1329C23.0698 12.9586 23.2059 12.7518 23.2975 12.5247C23.3891 12.2976 23.4345 12.0546 23.4311 11.8098V1.87402C23.4347 1.62678 23.3884 1.38133 23.295 1.15224C23.2016 0.92314 23.063 0.715051 22.8873 0.540306C22.7117 0.365561 22.5026 0.22772 22.2725 0.134948C22.0424 0.0421754 21.796 -0.00363889 21.5477 0.000225626Z" fill="#6596FF"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.22082 10.1992C4.22082 10.1992 3.21492 10.1998 3.21492 11.0495L3.21436 18.1807V18.1812V18.3214L3.21492 18.3225H3.2182C3.29526 24.7844 8.60459 30.0002 15.1461 30.0002C21.6643 30.0002 27.0222 24.8212 27.1375 18.3913H27.1429V18.1818V18.1807L27.1418 11.0495C27.1418 10.2002 26.1375 10.1992 26.1375 10.1992L4.22082 10.1992Z" fill="#6596FF"/>
                        <path d="M7.8592 20.389C8.86565 20.389 9.68154 19.5764 9.68154 18.5739C9.68154 17.5714 8.86565 16.7588 7.8592 16.7588C6.85275 16.7588 6.03687 17.5714 6.03687 18.5739C6.03687 19.5764 6.85275 20.389 7.8592 20.389Z" fill="white"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.66429 0.10761C8.18719 0.114931 7.73249 0.310479 7.39998 0.651338C7.06746 0.992196 6.88429 1.45052 6.89066 1.92574V11.8616C6.88257 12.1021 6.92317 12.3419 7.01001 12.5665C7.09686 12.7911 7.22819 12.996 7.39618 13.169C7.56418 13.342 7.7654 13.4796 7.98788 13.5736C8.21036 13.6676 8.44954 13.716 8.69119 13.716C8.93285 13.716 9.17203 13.6676 9.39451 13.5736C9.61699 13.4796 9.81821 13.342 9.9862 13.169C10.1542 12.996 10.2855 12.7911 10.3724 12.5665C10.4592 12.3419 10.4998 12.1021 10.4917 11.8616V1.92574C10.4949 1.68592 10.4499 1.44789 10.3591 1.22573C10.2684 1.00356 10.1339 0.801767 9.96351 0.63227C9.79314 0.462773 9.59039 0.329017 9.36724 0.238901C9.14409 0.148786 8.90506 0.104141 8.66429 0.10761Z" fill="#6596FF"/>
                        <path d="M22.1646 20.3929C23.1711 20.3929 23.987 19.5803 23.987 18.5778C23.987 17.5753 23.1711 16.7627 22.1646 16.7627C21.1582 16.7627 20.3423 17.5753 20.3423 18.5778C20.3423 19.5803 21.1582 20.3929 22.1646 20.3929Z" fill="white"/>
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M9.10772 21.5681C9.03045 21.5726 8.95609 21.5991 8.89343 21.6444C8.83077 21.6896 8.78243 21.7518 8.75413 21.8236C8.72583 21.8954 8.71876 21.9737 8.73374 22.0493C8.74872 22.125 8.78514 22.1948 8.83868 22.2504C9.02845 22.454 9.58625 23.1578 10.5813 23.7862C11.5763 24.4146 13.0381 24.9939 15.1116 25.0869H15.1261H15.1426C17.4764 25.0162 19.0027 24.483 19.9999 23.8769C20.9972 23.2707 21.4742 22.5669 21.6577 22.3205C21.6932 22.2784 21.7198 22.2294 21.7356 22.1767C21.7515 22.1239 21.7563 22.0685 21.7499 22.0138C21.7434 21.9591 21.7258 21.9063 21.6981 21.8586C21.6705 21.8109 21.6333 21.7694 21.5889 21.7366C21.5445 21.7038 21.4938 21.6804 21.44 21.6678C21.3861 21.6552 21.3303 21.6537 21.2759 21.6634C21.2214 21.6731 21.1696 21.6938 21.1235 21.7242C21.0774 21.7546 21.038 21.7941 21.0078 21.8402C20.7883 22.1349 20.4424 22.6628 19.5777 23.1884C18.7157 23.7123 17.3442 24.2091 15.1343 24.2788C13.2017 24.1898 11.8975 23.6607 11.0159 23.1039C10.132 22.5457 9.70053 21.9872 9.43472 21.7021C9.39392 21.6566 9.3433 21.6209 9.28666 21.5977C9.23003 21.5745 9.16885 21.5644 9.10772 21.5681Z"
                              fill="white"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_20084">
                            <rect width="30" height="30" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <h2 class="c-readycard__title"><?php esc_html_e('Ultimate Member', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Easily sync mobile numbers from user profiles and send automatic SMS notifications upon membership approval.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_18355)">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M13.1652 29.9254C7.36178 29.2198 2.47128 25.1613 0.680023 19.5643C0.435265 18.7995 0.17707 17.5992 0.0671532 16.7151C-0.0333559 15.9068 -0.0184635 13.9568 0.0945774 13.1249C0.344565 11.2851 0.766349 9.89617 1.55906 8.30245C2.73124 5.94584 4.4146 4.02292 6.5922 2.55302C7.3378 2.04973 7.52185 1.94204 8.32071 1.54166C9.84819 0.776089 11.462 0.291381 13.2199 0.0701815C13.9636 -0.0233938 16.0367 -0.0233938 16.7803 0.0701815C21.8525 0.708422 26.1854 3.76732 28.4412 8.30245C29.5255 10.4825 29.9974 12.5064 30 14.9885C30.0012 16.2787 29.9461 16.8563 29.7064 18.058C28.4572 24.3215 23.1699 29.1765 16.7806 29.9268C15.945 30.025 13.9777 30.0239 13.1652 29.9254ZM16.5813 29.267C19.3637 28.9413 21.8594 27.9 24.0069 26.1687C26.7375 23.9672 28.5575 20.8322 29.1631 17.2869C29.3121 16.4143 29.3689 14.4536 29.2713 13.5494C29.0793 11.7706 28.6281 10.2201 27.8411 8.63435C25.6906 4.30144 21.631 1.41086 16.7803 0.758659C15.86 0.634917 14.1402 0.634917 13.2199 0.758659C8.33281 1.41575 4.26953 4.32749 2.12442 8.70967C1.37827 10.234 0.9067 11.8683 0.727936 13.5494C0.631514 14.4562 0.688834 16.4188 0.837138 17.2869C1.19412 19.3769 1.88726 21.161 3.00001 22.8542C5.12485 26.0872 8.40823 28.3141 12.1721 29.075C13.5248 29.3484 15.2458 29.4234 16.5813 29.267ZM13.3021 27.7838C10.1252 27.352 7.17806 25.7382 5.15892 23.3247C2.45478 20.0924 1.4918 15.8179 2.54318 11.714C2.98071 10.0061 3.94503 8.12858 5.07719 6.78021C5.50091 6.27558 6.42284 5.36336 6.92084 4.95599C8.66246 3.53133 11.0038 2.53654 13.3843 2.20982C14.0548 2.11779 15.9454 2.11779 16.616 2.20982C18.9964 2.53654 21.3378 3.53133 23.0794 4.95599C23.5774 5.36336 24.4993 6.27558 24.923 6.78021C25.7586 7.77532 26.6369 9.29994 27.1021 10.5629C27.9687 12.9152 28.1105 15.713 27.4878 18.1712C26.902 20.4838 25.5899 22.7248 23.8656 24.3578C21.879 26.2393 19.3783 27.4274 16.6521 27.785C15.8568 27.8893 14.0739 27.8886 13.3021 27.7838ZM22.4649 22.4568C22.4865 22.404 22.5034 21.8675 22.5023 21.2646C22.5002 20.1543 22.4407 19.6522 22.2192 18.8802C21.9884 18.0756 21.5391 17.2607 21.0049 16.6775C20.2269 15.8281 18.8886 15.1728 17.7077 15.0629L17.3479 15.0294L15.7562 16.5984L14.1646 18.1674L12.5674 16.598L10.9702 15.0286L10.5583 15.0659C9.98898 15.1175 9.20695 15.3249 8.70325 15.5578C7.11823 16.2906 6.16562 17.7225 5.81819 19.8943C5.74278 20.3656 5.72059 22.1536 5.78709 22.4019L5.82744 22.5527H14.1265C21.9788 22.5527 22.4276 22.5474 22.4649 22.4568ZM25.3097 20.1517C25.3611 20.119 25.3643 19.9275 25.3236 19.3166C25.183 17.2042 24.6509 15.8162 23.6071 14.8391C22.8985 14.1758 21.8751 13.7845 20.8447 13.7831C20.5262 13.7828 20.5521 13.7638 20.001 14.399C19.7621 14.6743 19.7405 14.7184 19.8288 14.7498C20.5717 15.0132 21.1185 15.348 21.621 15.8473C22.0651 16.2885 22.3756 16.7404 22.6934 17.4079C23.0126 18.0785 23.2008 18.7002 23.3321 19.5179C23.3847 19.8455 23.4542 20.1316 23.4864 20.1538C23.5647 20.2076 25.2247 20.2056 25.3097 20.1517ZM15.0127 15.0116C16.1629 14.7739 17.1721 14.0817 17.827 13.0815C18.3144 12.3371 18.5035 11.6677 18.5038 10.6857C18.504 10.1102 18.4804 9.89097 18.3811 9.54569C17.9327 7.98718 16.7784 6.85061 15.2192 6.43234C14.6096 6.26882 13.6405 6.26806 13.0349 6.43025C11.4862 6.84603 10.3072 8.02302 9.87082 9.5891C9.71008 10.1659 9.69879 11.159 9.84655 11.7268C10.2143 13.1402 11.2377 14.3075 12.5424 14.8018C13.337 15.1028 14.2111 15.1769 15.0127 15.0112L15.0127 15.0116ZM19.3602 13.2682C19.915 13.044 20.2933 12.7871 20.7818 12.3027C21.3326 11.7566 21.6321 11.2797 21.8834 10.5487C22.0529 10.0557 22.0625 9.98563 22.0642 9.23321C22.0654 8.56317 22.0462 8.37009 21.94 8.00303C21.4862 6.43405 20.2533 5.2663 18.6621 4.89837C18.2286 4.79813 18.0394 4.78334 17.5032 4.80782C16.8126 4.83933 16.3664 4.94958 15.7521 5.2404C15.3872 5.41318 15.3621 5.47151 15.6299 5.5251C15.94 5.58721 16.6184 5.90044 17.0427 6.17748C18.5601 7.16841 19.4628 8.83979 19.4628 10.6583C19.4628 11.5631 19.219 12.5328 18.8163 13.2298L18.6765 13.4717L18.8552 13.4359C18.9535 13.4162 19.1808 13.3408 19.3602 13.2682Z"
                              fill="#C2410C"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_18355">
                            <rect width="30" height="30" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <h2 class="c-readycard__title"><?php esc_html_e('BuddyPress', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Keep your community engaged with SMS notifications for mentions, activity replies, private messages, and comments. Automatically send a welcome SMS to new members using existing profile mobile numbers.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_19944)">
                        <path d="M7.71876 0L4.64307 8.7998L16.0225 8.78535L8.26524 29.9999H17.6477L25.4226 8.79312L19.2586 0.0144526L7.71876 0Z" fill="#4668FF"/>
                        <path d="M7.71877 0L19.2586 0.0145768L16.0226 8.78535L4.64307 8.79992L7.71877 0Z" fill="#001FA4"/>
                        <path d="M16.0225 8.78542L19.2585 0.0146484L25.4225 8.79322L17.6476 30.0001H8.26514L16.0225 8.78542Z" fill="#4668FF"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_19944">
                            <rect width="30" height="30" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <a class="c-readycard__title" target="_blank" title="<?php esc_attr_e('Contact Form 7', 'wp-sms'); ?>" href="<?php echo esc_url('https://wp-sms-pro.com/contact-form-7-sms-integration/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>">
                    <?php esc_html_e('Contact Form 7', 'wp-sms'); ?>
                </a>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Get instant SMS alerts when visitors submit forms, and automatically send personalized SMS confirmations.', 'wp-sms'); ?>
                </p>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M28.6746 20.3734C28.6746 21.7434 27.7037 23.4265 26.5157 24.1119L17.2087 29.486C16.022 30.1713 14.0796 30.1713 12.8923 29.486L3.58595 24.1112C2.3993 23.4265 1.42847 21.7448 1.42847 20.3734V9.62525C1.42847 8.25519 2.3993 6.57278 3.58595 5.88809L12.893 0.514033C14.0796 -0.171344 16.022 -0.171344 17.2093 0.514033L26.5164 5.88809C27.703 6.57347 28.6752 8.25519 28.6752 9.62525V20.3734H28.6746Z" fill="#EA580C"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M12.4095 12.5109H24.7428V9.04199H12.4385C10.6788 9.04199 9.21983 9.64462 8.10351 10.8327C5.41855 13.6914 5.34546 20.8926 5.34546 20.8926H24.6463V14.3767H21.1787V17.4244H9.04676C9.12399 16.2895 9.64388 14.2588 10.6313 13.208C11.0788 12.7329 11.6428 12.5109 12.4095 12.5109Z" fill="white"/>
                </svg>
                <h2 class="c-readycard__title">
                    <?php esc_html_e('GravityForms', 'wp-sms'); ?>
                </h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e("Instantly alert admins via SMS upon form submissions and automatically send SMS confirmations to user-selected phone numbers.", 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_20183)">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.5476 1.4829C7.69355 2.02846 3.39895 4.94424 1.34527 9.0886C-0.718843 13.2541 -0.393897 17.9923 2.22525 21.9217C4.46797 25.2863 8.33036 27.5482 12.6311 28.0156C13.1004 28.0667 16.2714 28.0953 21.4255 28.0953H29.486L29.743 27.839L30 27.5826V25.7201V23.8576L29.743 23.6012L29.486 23.3448H27.2081H24.9303L25.438 22.7227C26.4596 21.4713 27.1766 20.1901 27.6569 18.758C28.6944 15.664 28.5079 12.3449 27.1326 9.43252C25.1895 5.31712 21.3442 2.43791 16.6967 1.61833C15.6899 1.44075 13.5451 1.37077 12.5476 1.4829ZM15.6149 6.26934C17.9999 6.62261 20.1625 7.88965 21.5745 9.76084C24.1939 13.2321 23.8454 17.6211 20.7052 20.7098C18.6432 22.7381 15.6841 23.6733 12.7285 23.2307C7.27275 22.4138 3.76426 17.1615 5.4032 12.2644C6.78939 8.12281 11.0885 5.59884 15.6149 6.26934Z" fill="#2D2D2D"/>
                        <path d="M8.75496 11.6575C8.72526 10.8469 8.82261 10.5677 9.21914 10.3265C9.45262 10.1844 9.63502 10.1792 14.4197 10.179L19.3783 10.1787L19.6341 10.3506C20.0272 10.6149 20.0887 10.7978 20.0646 11.629C20.0437 12.3453 20.0373 12.3687 19.7961 12.6093L19.549 12.8556H14.412H9.275L9.02791 12.6092C8.78921 12.3712 8.77991 12.3389 8.75496 11.6575Z" fill="#C2410C"/>
                        <path d="M8.75496 15.1262C8.72526 14.3155 8.82261 14.0363 9.21914 13.7952C9.44862 13.6555 9.61952 13.6479 12.53 13.6477L15.599 13.6474L15.8548 13.8193C16.248 14.0836 16.3095 14.2664 16.2852 15.0977C16.2643 15.814 16.258 15.8374 16.0167 16.0779L15.7697 16.3243H12.5223H9.275L9.02791 16.0778C8.78921 15.8398 8.77991 15.8075 8.75496 15.1262Z" fill="#C2410C"/>
                        <path d="M8.75496 18.5948C8.72526 17.7842 8.82261 17.5049 9.21914 17.2638C9.43176 17.1344 9.6041 17.1165 10.6404 17.1163C11.743 17.116 11.8363 17.1272 12.0755 17.2879C12.4686 17.5523 12.5301 17.735 12.5059 18.5663C12.4851 19.2827 12.4786 19.306 12.2375 19.5465L11.9904 19.7929H10.6327H9.275L9.02791 19.5465C8.78921 19.3085 8.77991 19.2762 8.75496 18.5948Z" fill="#C2410C"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_20183">
                            <rect width="30" height="27.5" fill="white" transform="translate(0 1.42871)"/>
                        </clipPath>
                    </defs>
                </svg>
                <h2 class="c-readycard__title"><?php esc_html_e('Quform', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Automatically send SMS alerts to admins when forms are submitted, and instantly notify users via SMS using phone numbers they select.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_14765_18148)">
                        <path d="M25.6061 4.39304C22.8925 1.6786 19.1419 0 15.0006 0C10.8581 0 7.10806 1.6786 4.39362 4.39304C1.6786 7.10749 0 10.8581 0 15C0 19.1419 1.6786 22.8925 4.39305 25.607C7.10749 28.322 10.8581 30 15.0006 30C19.1425 30 22.8931 28.3205 25.6067 25.607C28.3211 22.8919 29.9997 19.1419 29.9997 15C29.9997 10.8581 28.3205 7.10749 25.6061 4.39304ZM25.1113 25.111C22.524 27.6986 18.9488 29.2993 15 29.2993C11.0512 29.2993 7.47572 27.6986 4.88811 25.111C2.30051 22.5234 0.699895 18.9485 0.699895 15C0.699895 11.0512 2.30051 7.47629 4.88811 4.88868C7.47572 2.30108 11.0506 0.700465 14.9994 0.700465C18.9483 0.700465 22.5231 2.30108 25.1107 4.88868C27.6984 7.47629 29.2987 11.0512 29.2987 15C29.2993 18.9485 27.6986 22.5237 25.1113 25.111Z" fill="#35495C"/>
                        <path d="M27.9035 14.8749C27.8361 7.80569 22.0853 2.0957 15.0003 2.0957C7.91485 2.0957 2.16344 7.80626 2.09717 14.8755L8.01398 8.95866L9.99825 10.9429L5.66834 15.2728H24.3321L20.0021 10.9429L21.9864 8.95866L27.9035 14.8749ZM14.9998 12.6575L9.50175 6.88811H13.1555V4.04426C13.1555 3.30609 13.9856 2.70104 14.9998 2.70104C16.0139 2.70104 16.8441 3.30552 16.8441 4.04426V6.88811H20.4978L14.9998 12.6575Z" fill="#35495C"/>
                        <path
                            d="M16.604 22.2621C16.3109 22.0715 15.9396 21.9001 15.4916 21.7513C15.1491 21.6333 14.8671 21.5219 14.6472 21.4145C14.4289 21.3082 14.2678 21.1902 14.1647 21.0657C14.059 20.9389 14.0096 20.7869 14.0096 20.6126C14.0096 20.4732 14.0516 20.3407 14.1415 20.2152C14.2298 20.0901 14.3678 19.9859 14.5552 19.907C14.7446 19.827 14.9857 19.7839 15.2851 19.7825C15.5262 19.7836 15.7464 19.803 15.9456 19.8376C16.1424 19.8733 16.3169 19.9164 16.4663 19.9659C16.6177 20.017 16.74 20.0653 16.8363 20.1107L17.1694 19.1063C16.968 19.0051 16.7157 18.9212 16.4095 18.8532C16.1495 18.7957 15.8519 18.7626 15.5139 18.7512V17.7119H14.5983V18.8032C14.4515 18.8269 14.3107 18.8589 14.1775 18.8974C13.8407 18.9969 13.5513 19.1348 13.312 19.3151C13.0746 19.4945 12.8906 19.7045 12.7643 19.945C12.6375 20.1855 12.5749 20.4506 12.5724 20.7357C12.5741 21.0657 12.6606 21.3565 12.8312 21.6076C13.0017 21.859 13.2448 22.077 13.5588 22.2638C13.8713 22.45 14.2444 22.6106 14.6757 22.7457C14.9994 22.8494 15.2634 22.9577 15.4645 23.0688C15.6659 23.1794 15.8133 23.3013 15.905 23.4345C15.9987 23.5676 16.045 23.7219 16.0432 23.8944C16.0432 24.0838 15.9875 24.2481 15.879 24.39C15.7716 24.53 15.6127 24.64 15.4039 24.718C15.1951 24.7968 14.9403 24.8354 14.6415 24.838C14.3984 24.8363 14.1627 24.8154 13.9327 24.776C13.7045 24.7348 13.4902 24.6817 13.2928 24.6154C13.0934 24.5492 12.9192 24.4772 12.7678 24.3966L12.4458 25.4427C12.5915 25.5227 12.7732 25.5947 12.9957 25.661C13.2183 25.7278 13.4631 25.781 13.7313 25.8215C13.9976 25.861 14.2712 25.881 14.5495 25.8835L14.5983 25.883V26.9574H15.5139V25.7967C15.6302 25.7741 15.7407 25.7473 15.8459 25.7161C16.2132 25.6056 16.5183 25.4547 16.7597 25.2616C17.0028 25.0702 17.1828 24.8485 17.3022 24.5986C17.421 24.3486 17.4805 24.0841 17.4805 23.8024C17.4805 23.4725 17.4099 23.1805 17.2642 22.9294C17.1171 22.676 16.8983 22.454 16.604 22.2621Z"
                            fill="#35495C"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_14765_18148">
                            <rect width="30" height="30" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <h2 class="c-readycard__title">
                    <?php esc_html_e('Easy Digital Downloads', 'wp-sms'); ?>
                </h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Add mobile numbers at checkout, instantly notify admins of new orders, and automatically confirm orders with customers via SMS.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M15.4497 21.2241L16.7991 18.9586H13.1268L14.4763 21.2241L12.587 27.4319L14.9671 30L17.3389 27.4319L15.4496 21.2241H15.4497ZM22.0664 18.6887H21.4121L14.9672 29.7628L8.52227 18.6887H7.86797C5.89685 18.6887 4.28564 20.2999 4.28564 22.271V30H25.6488V22.271C25.6488 20.2999 24.0376 18.6887 22.0665 18.6887H22.0664ZM17.9687 8.99674C17.1263 8.99674 16.4393 9.68379 16.4393 10.5262H19.5063C19.5063 9.68383 18.8193 8.99674 17.9687 8.99674H17.9687ZM11.9573 8.99674C11.1148 8.99674 10.4278 9.68379 10.4278 10.5262H13.4948C13.4866 9.68383 12.7996 8.99674 11.9571 8.99674H11.9573ZM20.1771 5.32443H18.803L18.1569 3.70501H15.4661V2.62538C15.9732 2.42911 16.3249 1.93834 16.3249 1.36584C16.3249 0.613339 15.7115 0 14.959 0C14.2066 0 13.5932 0.61342 13.5932 1.36584C13.5932 1.93834 13.9531 2.42907 14.452 2.62538V3.70501H11.7612L11.115 5.32443H9.74919C7.14012 5.32443 5.14447 7.60637 5.62703 10.1582L7.05014 17.4455H22.8681L24.2912 10.1582C24.7819 7.60637 22.7945 5.32443 20.1772 5.32443H20.1771ZM22.3689 9.97821C22.3689 15.4908 7.56517 15.4908 7.56517 9.97821C7.56517 8.66957 8.57117 7.5818 9.87159 7.4673H20.0543C21.3629 7.58176 22.3689 8.66961 22.3689 9.97821Z"
                        fill="#D75676"/>
                </svg>
                <h2 class="c-readycard__title">
                    <?php esc_html_e('WP Job Manager', 'wp-sms'); ?>
                </h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Capture employer mobile numbers on job submissions, instantly notify admins of new listings, and automatically text employers when their job posts are approved.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="c-readycard c-readycard--integration">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.7604 11.8929L14.1136 2.85742L0.632191 25.7801L0 27.1732L4.39257 27.1732L30 8.79914H24.2076H19.2054L20.9155 11.1054L19.7793 11.9408L19.7604 11.8929ZM16.4275 14.4049L9.18427 19.7301C9.18427 19.7301 12.9395 12.5257 14.1333 10.4409L16.3984 14.3671L16.4275 14.4049Z" fill="#3A99D9"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.33765 27.1735H17.942L16.547 24.5518L20.5394 21.3924L20.6766 21.6209L23.9198 27.1735H28.1754L22.0806 16.1289L7.33765 27.1735Z" fill="#B8E179"/>
                </svg>
                <a class="c-readycard__title" target="_blank" title="<?php esc_attr_e('Awesome Support', 'wp-sms'); ?>" href="<?php echo esc_url('https://wp-sms-pro.com/awesome-support-sms-integration/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>">
                    <?php esc_html_e('Awesome Support', 'wp-sms'); ?>
                </a>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Instantly alert admins via SMS for new tickets and replies, and automatically notify users when their support tickets receive responses.', 'wp-sms'); ?>
                </p>
                <?php if (!$is_pro): ?>
                    <div class="u-flex u-align-center">
                        <a title="<?php esc_attr_e('All-in-One Required', 'wp-sms'); ?>" target="_blank" href="<?php echo esc_url('https://wp-sms-pro.com/pricing/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" class="c-readycard__badge">
                            <?php esc_html_e('All-in-One Required', 'wp-sms'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="c-ready-row">
        <h3 class="c-ready__title"><?php esc_html_e('Our products', 'wp-sms'); ?></h3>
        <div class="c-ready__items u-flex u-align-stretch u-content-sp">
            <div class="c-readycard c-readycard__half">
                <svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M35.3228 24.2898C34.0665 28.1656 31.4722 31.468 28.0039 33.606C24.5356 35.744 20.4198 36.5782 16.3927 35.9593C12.3657 35.3404 8.69027 33.3087 6.02408 30.2279C3.3579 27.1471 1.87493 23.2181 1.84051 19.1439C1.8061 15.0697 3.22248 11.1162 5.83624 7.99081C8.45 4.86538 12.0906 2.77195 16.1066 2.08509C20.1226 1.39823 24.252 2.16276 27.7559 4.24189C31.2597 6.32102 33.9095 9.57907 35.2311 13.4331H37.1661C35.8289 9.06955 32.9657 5.33311 29.1002 2.90701C25.2346 0.480915 20.6249 -0.472713 16.114 0.220504C11.6031 0.91372 7.49245 3.20746 4.53371 6.68229C1.57496 10.1571 -0.0341747 14.5809 0.000550502 19.1446C0.0352757 23.7083 1.71154 28.107 4.72282 31.5364C7.7341 34.9658 11.8792 37.1967 16.4001 37.8212C20.921 38.4457 25.5157 37.4221 29.3439 34.9374C33.1721 32.4528 35.9781 28.6732 37.2487 24.2898H35.3228Z" fill="black"/>
                    <path
                        d="M35.7287 17.0908L34.7486 16.5833L30.9052 24.004C30.706 23.8077 30.4688 23.6542 30.2081 23.5529C29.9474 23.4517 29.6688 23.4048 29.3893 23.4153C29.1098 23.4257 28.8355 23.4932 28.583 23.6136C28.3306 23.734 28.1055 23.9047 27.9215 24.1153L24.2867 19.2547C24.2629 19.2183 24.23 19.1917 24.2048 19.1574C24.2715 18.9573 24.3069 18.7481 24.3098 18.5372C24.3143 18.2357 24.2529 17.9369 24.1299 17.6617C24.0068 17.3865 23.8252 17.1415 23.5976 16.9437C23.37 16.746 23.102 16.6004 22.8123 16.5171C22.5226 16.4337 22.2182 16.4146 21.9203 16.4612C21.6225 16.5077 21.3384 16.6188 21.0879 16.7865C20.8374 16.9543 20.6266 17.1748 20.4702 17.4325C20.3138 17.6902 20.2156 17.979 20.1824 18.2786C20.1492 18.5783 20.1819 18.8815 20.2781 19.1672C20.2571 19.1966 20.2291 19.2183 20.2081 19.2491L17.6549 23.6505C17.2674 23.3066 16.7638 23.1226 16.2459 23.1356C15.728 23.1486 15.2342 23.3576 14.8645 23.7205L11.4831 18.0856C11.566 17.8633 11.6096 17.6283 11.6119 17.3911C11.6019 16.8486 11.3794 16.3317 10.9922 15.9515C10.605 15.5714 10.0841 15.3584 9.54146 15.3584C8.99884 15.3584 8.4779 15.5714 8.09069 15.9515C7.70349 16.3317 7.48097 16.8486 7.47099 17.3911C7.47099 17.3974 7.47099 17.403 7.47099 17.4093C7.40099 17.4702 7.33518 17.5179 7.26797 17.5851L1.22705 23.7527L2.01603 24.5228L7.84483 18.5722C8.00197 18.8001 8.20361 18.9938 8.43761 19.1417C8.67161 19.2896 8.93313 19.3886 9.20641 19.4328C9.47969 19.4769 9.75909 19.4653 10.0278 19.3986C10.2964 19.3319 10.5488 19.2115 10.7697 19.0447L14.2673 24.8763C14.221 25.1583 14.2337 25.4469 14.3046 25.7238C14.3754 26.0006 14.5029 26.2598 14.679 26.4849C14.8551 26.71 15.076 26.8962 15.3276 27.0316C15.5793 27.167 15.8563 27.2488 16.1412 27.2718C16.4261 27.2948 16.7126 27.2584 16.9827 27.165C17.2528 27.0717 17.5006 26.9233 17.7105 26.7293C17.9204 26.5353 18.0878 26.2999 18.2021 26.038C18.3164 25.776 18.3751 25.4932 18.3746 25.2074C18.3731 25.0421 18.3515 24.8775 18.3102 24.7174L20.9607 20.1494C21.3279 20.4492 21.7887 20.6108 22.2627 20.6059C22.7368 20.6011 23.1941 20.4301 23.5551 20.1228L27.4111 25.2788C27.4005 25.3484 27.3935 25.4185 27.3901 25.4889C27.4001 26.0314 27.6226 26.5483 28.0098 26.9285C28.397 27.3086 28.918 27.5216 29.4606 27.5216C30.0032 27.5216 30.5242 27.3086 30.9114 26.9285C31.2986 26.5483 31.5211 26.0314 31.5311 25.4889C31.5277 25.4075 31.5193 25.3263 31.5059 25.2459L35.7287 17.0908ZM9.53691 18.9992C9.21845 18.9992 8.90714 18.9048 8.64235 18.7278C8.37755 18.5509 8.17118 18.2994 8.04931 18.0052C7.92744 17.711 7.89555 17.3873 7.95768 17.0749C8.01981 16.7626 8.17316 16.4757 8.39835 16.2505C8.62353 16.0253 8.91044 15.8719 9.22278 15.8098C9.53512 15.7477 9.85887 15.7796 10.1531 15.9014C10.4473 16.0233 10.6988 16.2297 10.8757 16.4945C11.0526 16.7593 11.1471 17.0706 11.1471 17.389C11.1471 17.6005 11.1054 17.8099 11.0245 18.0052C10.9436 18.2006 10.825 18.3781 10.6755 18.5276C10.5259 18.6771 10.3484 18.7957 10.1531 18.8766C9.95774 18.9576 9.74836 18.9992 9.53691 18.9992ZM16.3045 26.8281C15.986 26.8281 15.6747 26.7337 15.4099 26.5567C15.1452 26.3798 14.9388 26.1283 14.8169 25.8341C14.695 25.5399 14.6631 25.2162 14.7253 24.9038C14.7874 24.5915 14.9408 24.3046 15.1659 24.0794C15.3911 23.8542 15.678 23.7008 15.9904 23.6387C16.3027 23.5766 16.6265 23.6085 16.9207 23.7303C17.2149 23.8522 17.4664 24.0586 17.6433 24.3234C17.8202 24.5882 17.9147 24.8995 17.9147 25.2179C17.9147 25.645 17.745 26.0545 17.4431 26.3565C17.1411 26.6585 16.7315 26.8281 16.3045 26.8281ZM22.2425 20.12C21.9241 20.12 21.6127 20.0256 21.348 19.8487C21.0832 19.6717 20.8768 19.4203 20.7549 19.126C20.633 18.8318 20.6012 18.5081 20.6633 18.1957C20.7254 17.8834 20.8788 17.5965 21.104 17.3713C21.3291 17.1461 21.616 16.9928 21.9284 16.9306C22.2407 16.8685 22.5645 16.9004 22.8587 17.0223C23.1529 17.1441 23.4044 17.3505 23.5813 17.6153C23.7582 17.8801 23.8527 18.1914 23.8527 18.5099C23.8527 18.9369 23.683 19.3464 23.3811 19.6484C23.0791 19.9504 22.6696 20.12 22.2425 20.12ZM29.4617 27.0962C29.1432 27.0962 28.8319 27.0018 28.5671 26.8249C28.3023 26.6479 28.0959 26.3965 27.9741 26.1023C27.8522 25.808 27.8203 25.4843 27.8824 25.1719C27.9446 24.8596 28.0979 24.5727 28.3231 24.3475C28.5483 24.1223 28.8352 23.969 29.1475 23.9068C29.4599 23.8447 29.7836 23.8766 30.0778 23.9985C30.3721 24.1203 30.6235 24.3267 30.8005 24.5915C30.9774 24.8563 31.0718 25.1676 31.0718 25.4861C31.0718 25.9131 30.9022 26.3227 30.6002 26.6246C30.2983 26.9266 29.8887 27.0962 29.4617 27.0962Z"
                        fill="black"/>
                </svg>
                <h2 class="c-readycard__title"><?php esc_html_e('WP Statistics', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('The #1 Privacy-Focused Analytics tool for WordPress.', 'wp-sms'); ?>
                </p>
                <a class="c-btn" href="<?php echo esc_url('https://wp-statistics.com/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" target="_blank" title="<?php esc_attr_e('Learn more', 'wp-sms'); ?>">
                    <?php esc_html_e('Learn more', 'wp-sms'); ?>
                </a>
            </div>
            <div class="c-readycard c-readycard__half">
                <svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M6.29756e-06 18.9991C6.29756e-06 8.50632 8.50633 0 19 0C25.6854 0 31.5642 3.45177 34.9498 8.67017L24.5631 19.2199L24.5546 19.2284L24.5478 19.236C24.4505 19.3363 24.3324 19.4141 24.2019 19.464C24.0714 19.5139 23.9315 19.5347 23.7921 19.525C23.6527 19.5152 23.5171 19.475 23.3949 19.4074C23.2726 19.3397 23.1666 19.2462 23.0842 19.1333L20.1868 15.1628C17.702 11.7569 12.7289 11.4564 9.85189 14.5388L0.747069 24.2914C0.250055 22.5713 -0.0014511 20.7896 6.29756e-06 18.9991ZM3.41527 29.8698C6.84921 34.7851 12.5498 38 19 38C29.4937 38 38.0009 29.4928 38.0009 18.9991C38.0009 17.3981 37.8031 15.8428 37.4295 14.3572L28.6719 23.2523C25.772 26.2321 20.8855 25.8874 18.4338 22.5265L15.5355 18.5577C15.4522 18.4434 15.3447 18.3489 15.2207 18.281C15.0966 18.2132 14.9591 18.1735 14.8179 18.165C14.6768 18.1565 14.5355 18.1793 14.4042 18.2318C14.2729 18.2843 14.1548 18.3651 14.0584 18.4686L3.41612 29.8698H3.41527Z"
                          fill="#F22F46"/>
                </svg>
                <h2 class="c-readycard__title"><?php esc_html_e('WP SlimStat', 'wp-sms'); ?></h2>
                <p class="c-readycard__desc">
                    <?php esc_html_e('Maximize your business potential with data analytics.', 'wp-sms'); ?>
                </p>
                <a class="c-btn" href="<?php echo esc_url('https://wp-slimstat.com/?utm_source=wp-sms&utm_medium=link&utm_campaign=onboarding'); ?>" target="_blank" title="<?php esc_attr_e('Learn more', 'wp-sms'); ?>">
                    <?php esc_html_e('Learn more', 'wp-sms'); ?>
                </a>
            </div>
        </div>
    </div>

</form>